#!/usr/bin/env python
# -*- coding: utf-8 -*-
'''
Module utilisateur Franais pdagogique pour hepialight2
Contient des fonctions pour interfacer la carte:
    - Accs aux LEDs
    - Accs  l'acclromtre
    - Accs au pav tactile
'''

__author__ = 'Adrien Lescourt'
__copyright__ = 'hepialight2 hepia 2017'
__credits__ = ['Adrien Lescourt']
__version__ = '1.0.0'
__email__ = 'adrien.lescourt@hesge.ch'
__status__ = 'Prototype'

import time
from Hepialight import touch, screen, accel, uart

# Constantes
NBR_LIGNES = 10
NBR_COLONNES = 10

# Couleurs
ROUGE = 0x2F0000
VERT = 0x002F00
BLEU = 0x00002F

# Coordonnes
N = 0
S = 1
E = 2
O = 3

_accel = accel()
_seuil_accel = 0.3


def delai(delai_en_sec=1):
    '''Met en pause l'excution du programme

    :delai_en_sec: Temps de la pause en seconde

    '''
    time.sleep(delai_en_sec)


def allumer_tout(couleur=ROUGE):
    '''Allume tout l'cran selon la couleur passe en paramtre

    :couleur: Couleur de l'cran

    '''
    for i in range(NBR_LIGNES):
        for j in range(NBR_COLONNES):
            screen.set_led((i, j), couleur)


def eteindre_tout():
    '''teint tout l'cran

    '''
    for i in range(NBR_LIGNES):
        for j in range(NBR_COLONNES):
            screen.set_led((i, j), 0)


def allumer_ligne(num_ligne, couleur=ROUGE):
    '''Allume tout une ligne de la couleur choisi

    :num_ligne: numro de la ligne entre 0 et 9
    :couleur: couleur des LEDs

    '''
    for i in range(NBR_COLONNES):
        screen.set_led((i, num_ligne), couleur)


def allumer_colonne(num_colonne, couleur=ROUGE):
    '''Allume tout une colonne de la couleur choisi

    :num_colonne: numro de la colonne entre 0 et 9
    :couleur: couleur des LEDs

    '''
    for j in range(NBR_LIGNES):
        screen.set_led((num_colonne, j), couleur)


def allumer_led(pos_x, pos_y, couleur=ROUGE):
    '''Allume la LED a la position pos_x, pos_y de la couleur choisi

    :pos_x: numero de la ligne entre 0 et 9
    :pos_y: numero de la colonne entre 0 et 9
    :couleur: couleur de la LED

    '''
    screen.set_led((pos_x, pos_y), couleur)


def eteindre_led(pos_x, pos_y):
    '''Eteint la LED a la position pos_x, pos_y

    :x: numero de la ligne entre 0 et 9
    :y: numero de la colonne entre 0 et 9

    '''
    screen.set_led((pos_x, pos_y), 0)


def penche_gauche():
    '''Dtecte si la carte penche sur la gauche
    :returns: True si la carte penche sur la gauche, False sinon

    '''
    return _accel.get_axis()[0] > _seuil_accel


def penche_droite():
    '''Dtecte si la carte penche sur la droite
    :returns: True si la carte penche sur la droite, False sinon

    '''
    return _accel.get_axis()[0] < -_seuil_accel


def penche_avant():
    '''Dtecte si la carte penche en avant
    :returns: True si la carte penche sur en avant, False sinon

    '''
    return _accel.get_axis()[1] > _seuil_accel


def penche_arriere():
    '''Dtecte si la carte penche en arrire
    :returns: True si la carte penche sur en arrire, False sinon

    '''
    return _accel.get_axis()[1] < -_seuil_accel


def touche_bas_gauche():
    '''Dtecte si le pav tactile infrieur gauche est press
    :returns: True si press, False sinon

    '''
    return touch.read(0)


def touche_bas_droite():
    '''Dtecte si le pav tactile infrieur droit est press
    :returns: True si press, False sinon

    '''
    return touch.read(1)


def touche_haut_gauche():
    '''Dtecte si le pav tactile suprieur gauche est press
    :returns: True si press, False sinon

    '''
    return touch.read(2)


def touche_haut_droite():
    '''Dtecte si le pav tactile suprieur droit est press
    :returns: True si press, False sinon

    '''
    return touch.read(3)


def envoyer_msg(ID, data):
    '''Envoi une valeur vers une des carte voisines
    :ID: quelle carte
    :data: la valeur

    '''
    uart.send_to(ID, data)


def recevoir_msg(ID):
    '''Dtecte si le pav tactile suprieur droit est press
    :returns: True si press, False sinon

    '''
    return uart.recv(ID)